package ru.yandex.direct.jobs.configuration;

import java.util.Collections;
import java.util.List;

import ru.yandex.direct.scheduler.support.ParametersSource;

public class MySqlClustersParametersSource implements ParametersSource<String> {
    private final List<String> clustersNames;

    public MySqlClustersParametersSource(List<String> clustersNames) {
        this.clustersNames = Collections.unmodifiableList(clustersNames);
    }

    @Override
    public List<String> getAllParamValues() {
        return clustersNames;
    }

    @Override
    public String convertParamToString(String clusterName) {
        return clusterName;
    }

    @Override
    public String convertStringToParam(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        return str;
    }
}
