package ru.yandex.direct.jobs.configuration;

import java.util.StringJoiner;

import ru.yandex.direct.ytwrapper.model.YtCluster;

public class PpcDataExportParameter {
    private final YtCluster ytCluster;
    private final String confFilePath;

    public PpcDataExportParameter(YtCluster ytCluster, String confFilePath) {
        this.ytCluster = ytCluster;
        this.confFilePath = confFilePath;
    }

    public YtCluster getYtCluster() {
        return ytCluster;
    }

    public String getConfFilePath() {
        return confFilePath;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", PpcDataExportParameter.class.getSimpleName() + "[", "]")
                .add("ytCluster=" + ytCluster)
                .add("confFilePath='" + confFilePath + "'")
                .toString();
    }
}
