package ru.yandex.direct.jobs.configuration;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.scheduler.support.ParametersSource;

@Component
public class PpcShardsParametersSource implements ParametersSource<Integer> {
    private final ShardHelper shardHelper;

    @Autowired
    public PpcShardsParametersSource(ShardHelper shardHelper) {
        this.shardHelper = shardHelper;
    }

    @Override
    public List<Integer> getAllParamValues() {
        return new ArrayList<>(shardHelper.dbShards());
    }

    @Override
    public String convertParamToString(Integer paramValue) {
        return paramValue.toString();
    }

    @Override
    public Integer convertStringToParam(String string) {
        return Integer.parseInt(string);
    }
}
