package ru.yandex.direct.jobs.configuration;

import java.util.List;

import ru.yandex.direct.jobs.recommendations.WorkerInfo;
import ru.yandex.direct.scheduler.support.ParametersSource;

import static java.util.Collections.unmodifiableList;

/**
 * Вытаскивает из конфига все кластера с номерами worker-ов.
 */
public class RecommendationsApplicationParametersSource implements ParametersSource<WorkerInfo> {
    private final List<WorkerInfo> workerInfos;

    RecommendationsApplicationParametersSource(List<WorkerInfo> workerInfos) {
        this.workerInfos = workerInfos;
    }

    @Override
    public List<WorkerInfo> getAllParamValues() {
        return unmodifiableList(workerInfos);
    }

    @Override
    public String convertParamToString(WorkerInfo paramValue) {
        return paramValue.toString();
    }

    @Override
    public WorkerInfo convertStringToParam(String string) {
        return WorkerInfo.valueOf(string);
    }
}
