package ru.yandex.direct.jobs.configuration;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.scheduler.support.ParametersSource;
import ru.yandex.direct.ytwrapper.model.YtCluster;

import static java.util.Collections.unmodifiableList;

/**
 * Базовый класс для парамтеризаторов.
 * Потребовался из-за необходимость разделять разные типы классами (для указания в аннотации).
 */
@ParametersAreNonnullByDefault
abstract class YtClustersParametersSource implements ParametersSource<YtCluster> {
    private final List<YtCluster> clusters;

    protected YtClustersParametersSource(List<YtCluster> clusters) {
        this.clusters = clusters;
    }

    @Override
    public List<YtCluster> getAllParamValues() {
        return unmodifiableList(clusters);
    }

    @Override
    public String convertParamToString(YtCluster paramValue) {
        return paramValue.toString();
    }

    @Override
    public YtCluster convertStringToParam(String string) {
        return YtCluster.valueOf(string);
    }
}
