package ru.yandex.direct.jobs.contentpromotion;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.contentpromotion.model.ContentPromotionContent;
import ru.yandex.direct.env.EnvironmentType;
import ru.yandex.direct.libs.collections.model.serpdata.CollectionSerpData;

import static ru.yandex.direct.core.entity.contentpromotion.type.collection.ContentPromotionCollectionUtils.convertToPreviewUrl;

@ParametersAreNonnullByDefault
public class ContentPromotionUtils {

    public static ContentPromotionContent convertToContentPromotionContent(CollectionSerpData serpData,
                                                                           EnvironmentType environmentType) {
        return new ContentPromotionContent()
                .withMetadata(serpData.getNormalizedJson())
                .withPreviewUrl(convertToPreviewUrl(serpData.getThumbId(), environmentType));
    }
}
