package ru.yandex.direct.jobs.contentpromotion.collection;

import java.time.Duration;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.common.db.PpcProperty;
import ru.yandex.direct.env.EnvironmentType;
import ru.yandex.direct.jobs.contentpromotion.collection.receivechanges.ReceiveCollectionsChangesJob;
import ru.yandex.direct.jobs.contentpromotion.collection.updatecontent.UpdateContentCollectionsJob;

import static ru.yandex.direct.common.db.PpcPropertyNames.ENABLE_CONTENT_PROMOTION_COLLECTIONS_JOB;

/**
 * Холдер для проперти ENABLE_CONTENT_PROMOTION_COLLECTIONS_JOB.
 * Используется в джобах {@link UpdateContentCollectionsJob} и {@link ReceiveCollectionsChangesJob} для переключения
 * с одной джобы на другую.
 */
public class UpdateCollectionsPropertyHolder {

    private final PpcProperty<Boolean> collectionsJobsProperty;

    public UpdateCollectionsPropertyHolder(PpcPropertiesSupport ppcPropertiesSupport, EnvironmentType environmentType) {
        this.collectionsJobsProperty = environmentType.isDevelopment() ?
                ppcPropertiesSupport.get(ENABLE_CONTENT_PROMOTION_COLLECTIONS_JOB) :
                ppcPropertiesSupport.get(ENABLE_CONTENT_PROMOTION_COLLECTIONS_JOB, Duration.ofMinutes(1L));
    }

    public boolean isUpdateContentCollectionsJobEnabled() {
        return Boolean.TRUE.equals(collectionsJobsProperty.get());
    }

    public boolean isReceiveCollectionsChangesJobEnabled() {
        return Boolean.FALSE.equals(collectionsJobsProperty.get());
    }
}
