package ru.yandex.direct.jobs.contentpromotion.collection.receivechanges;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.binlogbroker.logbroker_utils.reader.impl.LogbrokerBatchReaderImpl;
import ru.yandex.direct.jobs.contentpromotion.collection.receivechanges.model.CollectionChangeInfo;
import ru.yandex.direct.utils.JsonUtils;
import ru.yandex.kikimr.persqueue.consumer.SyncConsumer;
import ru.yandex.kikimr.persqueue.consumer.transport.message.inbound.data.MessageBatch;
import ru.yandex.kikimr.persqueue.consumer.transport.message.inbound.data.MessageData;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

@ParametersAreNonnullByDefault
public class CollectionsChangesLogbrokerReader extends LogbrokerBatchReaderImpl<CollectionChangeInfo> {

    private static final Logger logger = LoggerFactory.getLogger(CollectionsChangesLogbrokerReader.class);

    public CollectionsChangesLogbrokerReader(Supplier<SyncConsumer> logbrokerConsumerSupplier,
                                             boolean logbrokerNoCommit) {
        super(logbrokerConsumerSupplier, logbrokerNoCommit);
    }

    CollectionsChangesLogbrokerReader(Supplier<SyncConsumer> logbrokerConsumerSupplier,
                                      boolean logbrokerNoCommit,
                                      MetricRegistry sensorsRegistry) {
        super(logbrokerConsumerSupplier, logbrokerNoCommit, sensorsRegistry);
    }

    @Override
    protected List<CollectionChangeInfo> batchDeserialize(MessageBatch messageBatch) {
        List<CollectionChangeInfo> data = new ArrayList<>();

        for (MessageData messageData : messageBatch.getMessageData()) {
            CollectionChangeInfo collectionChangeInfo;

            try {
                collectionChangeInfo = JsonUtils.fromJson(messageData.getDecompressedData(), CollectionChangeInfo.class);
            } catch (IllegalArgumentException e) {
                logger.error("Got error parsing message", e);
                continue;
            }

            logger.info("Object - {}", collectionChangeInfo);

            data.add(collectionChangeInfo);
        }

        return data;
    }

    @Override
    protected int count(List<CollectionChangeInfo> e) {
        return e.size();
    }
}
