package ru.yandex.direct.jobs.contentpromotion.collection.receivechanges.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Информация об изменении коллекции.
 */
@ParametersAreNonnullByDefault
public class CollectionChangeInfo {

    @JsonProperty("board_id")
    private String boardId;

    @JsonProperty("datetime")
    private String utcDateTime;

    @JsonProperty("event")
    private CollectionChangeStatus collectionChangeStatus;

    public String getBoardId() {
        return boardId;
    }

    public String getUtcDateTime() {
        return utcDateTime;
    }

    public CollectionChangeStatus getCollectionChangeStatus() {
        return collectionChangeStatus;
    }

    public CollectionChangeInfo withBoardId(String boardId) {
        this.boardId = boardId;
        return this;
    }

    public CollectionChangeInfo withCollectionChangeStatus(CollectionChangeStatus collectionChangeStatus) {
        this.collectionChangeStatus = collectionChangeStatus;
        return this;
    }

    @Override
    public String toString() {
        return "CollectionChangeInfo{" +
                "boardId='" + boardId + '\'' +
                ", utcDateTime='" + utcDateTime + '\'' +
                ", collectionChangeStatus=" + collectionChangeStatus +
                '}';
    }
}
