package ru.yandex.direct.jobs.contentpromotion.collection.updatecontent;

import java.time.Duration;
import java.util.function.Supplier;

import ru.yandex.direct.jobs.contentpromotion.common.ContentPromotionJobConfiguration;

public class ContentPromotionCollectionJobConfiguration implements ContentPromotionJobConfiguration {
    private final Supplier<Boolean> launchCollectionsJob;

    public ContentPromotionCollectionJobConfiguration(Supplier<Boolean> launchCollectionsJob) {
        this.launchCollectionsJob = launchCollectionsJob;
    }

    @Override
    public int getChunkSize() {
        return 1;
    } //Есть ручка для получения данных только по одной коллекции

    @Override
    public int getRefreshCount() {
        return 15;
    }

    @Override
    public Duration getGracePeriod() {
        return Duration.ofHours(12);
    }

    @Override
    public boolean doJob() {return launchCollectionsJob.get(); } //включаем по проперте
}
