package ru.yandex.direct.jobs.contentpromotion.common;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.contentpromotion.model.ContentPromotionContent;
import ru.yandex.direct.core.entity.contentpromotionvideo.model.ContentPromotionVideo;
import ru.yandex.direct.model.AppliedChanges;

/**
 * Запрос на обновление баннера продвижения контента, содержит информацию о том, надо ли его переотправлять на
 * модерацию и в БК
 */
@ParametersAreNonnullByDefault
public class BannerUpdateRequest {
    private Long contentId;
    private boolean shouldModerate;
    private boolean shouldSyncToBs;

    private BannerUpdateRequest(Long contentId, boolean shouldModerate, boolean shouldSyncToBs) {
        this.contentId = contentId;
        this.shouldModerate = shouldModerate;
        this.shouldSyncToBs = shouldSyncToBs;
    }

    public static BannerUpdateRequest fromContentVideoChanges(AppliedChanges<ContentPromotionVideo> appliedChanges) {
        return new BannerUpdateRequest(
                appliedChanges.getModel().getContentPromotionVideoId(),
                appliedChanges.changed(ContentPromotionVideo.IS_INACCESSIBLE),
                appliedChanges.changed(ContentPromotionVideo.VIDEO_METADATA_MODIFY_TIME));
    }

    public static BannerUpdateRequest fromContentPromotionChanges(
            AppliedChanges<ContentPromotionContent> appliedChanges) {
        return new BannerUpdateRequest(
                appliedChanges.getModel().getId(),
                appliedChanges.changed(ContentPromotionContent.IS_INACCESSIBLE),
                appliedChanges.changed(ContentPromotionContent.METADATA_MODIFY_TIME));
    }

    public Long getContentId() {
        return contentId;
    }

    public boolean isShouldModerate() {
        return shouldModerate;
    }

    public boolean isShouldSyncToBs() {
        return shouldSyncToBs;
    }

    public boolean needToUpdateBanner() {
        return shouldModerate || shouldSyncToBs;
    }
}
