package ru.yandex.direct.jobs.contentpromotion.common;

import java.time.Duration;

/**
 * Конфигурация для запуска джобы по обновлению продвигаемого контента
 * Определяет, по скольку записей берём из шарда для обновления, сколько обновляем за один поход во внешний сервис,
 * через сколько времени считаем контент  устаревшим и начинаем обновлять
 */
public interface ContentPromotionJobConfiguration {
    /**
     * Сколько записей из числа обновляемых джобой берём для похода во внешний сервис
     */
    int getChunkSize();

    /**
     * Cколько записей берём из шарда для обновления за один запуск джобы
     */
    int getRefreshCount();

    /**
     * Период, в течение которого считаем контент "свежим" и не обновляем
     */
    Duration getGracePeriod();

    /**
     * Выполнять ли содержательные действия при запуске джобы
     */
    boolean doJob();
}
