package ru.yandex.direct.jobs.copy

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod
import ru.yandex.direct.core.entity.dbqueue.DbQueueJobTypes
import ru.yandex.direct.dbqueue.repository.DbQueueRepository
import ru.yandex.direct.env.NonDevelopmentEnvironment
import ru.yandex.direct.env.ProductionOnly
import ru.yandex.direct.jobs.base.dbqueuemonitoring.BaseDbQueueMonitoringJob
import ru.yandex.direct.juggler.check.annotation.JugglerCheck
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification
import ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_1_NOT_READY
import ru.yandex.direct.juggler.check.model.NotificationRecipient
import ru.yandex.direct.scheduler.Hourglass
import ru.yandex.direct.scheduler.HourglassDaemon

@JugglerCheck(
    ttl = JugglerCheck.Duration(minutes = 10),
    tags = [DIRECT_PRIORITY_1_NOT_READY],
    notifications = [
        OnChangeNotification(
            recipient = [NotificationRecipient.CHAT_CAMPAIGN_COPY_MONITORING],
            method = [NotificationMethod.TELEGRAM],
        ),
    ],
    needCheck = ProductionOnly::class,
)
@HourglassDaemon(runPeriod = 60)
@Hourglass(periodInSeconds = 60, needSchedule = NonDevelopmentEnvironment::class)
class CampaignCopyMonitoringJob(
    dbQueueRepository: DbQueueRepository,
) : BaseDbQueueMonitoringJob(dbQueueRepository) {

    override fun dbQueueJobType() = DbQueueJobTypes.CAMPAIGNS_COPY
    override fun typeLabel() = "campaign_copy"
}
