package ru.yandex.direct.jobs.copy.copyreport;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import ru.yandex.direct.core.copyentity.EntityContext;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.campaign.model.BaseCampaign;
import ru.yandex.direct.core.entity.mdsfile.model.MdsFileSaveRequest;

public class CopyReportContext {
    Long jobId;
    Long clientId;
    String loginFrom;
    String loginTo;
    EntityContext entityContext;
    Set<Long> failedCampaignIds;
    Map<Long, Long> oldCampaignIdsToNewCampaignIds;
    Map<Long, Set<Long>> oldCampaignIdsToOldAdGroupIds;
    Map<Long, Long> oldAdGroupIdsToNewAdGroupIds;
    Map<CopyReportType, String> result;
    List<MdsFileSaveRequest> requests;

    public CopyReportContext(Long jobId, Long clientId, String loginFrom, String loginTo, EntityContext entityContext,
                             Set<Long> failedCampaignIds) {
        this.jobId = jobId;
        this.clientId = clientId;
        this.loginFrom = loginFrom;
        this.loginTo = loginTo;
        this.entityContext = entityContext;
        this.failedCampaignIds = failedCampaignIds;
        result = new EnumMap<>(CopyReportType.class);
        requests = new ArrayList<>();
        fillMappings();
    }

    private void fillMappings() {
        oldCampaignIdsToNewCampaignIds = entityContext.getCopyMappingByClass(BaseCampaign.class);
        oldCampaignIdsToOldAdGroupIds = entityContext.getIdRelations(
                BaseCampaign.class,
                AdGroup.class);
        oldAdGroupIdsToNewAdGroupIds = entityContext.getCopyMappingByClass(AdGroup.class);
    }
}
