package ru.yandex.direct.jobs.counterbydomain

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.db.PpcPropertyNames
import ru.yandex.direct.config.DirectConfig
import ru.yandex.direct.env.ProductionOnly
import ru.yandex.direct.jobs.counterbydomain.CounterByDomainUtils.COUNTERS_BY_DOMAIN_HIT_LOG_CONFIG_BRANCH
import ru.yandex.direct.jobs.counterbydomain.CounterByDomainUtils.PARSED_LOG_FOLDER
import ru.yandex.direct.jobs.yt.ExecuteYQLAndExportDataJob
import ru.yandex.direct.juggler.JugglerStatus
import ru.yandex.direct.juggler.check.annotation.JugglerCheck
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification
import ru.yandex.direct.juggler.check.model.CheckTag
import ru.yandex.direct.juggler.check.model.NotificationRecipient
import ru.yandex.direct.scheduler.Hourglass
import ru.yandex.direct.ytwrapper.client.YtProvider

/**
 * Запускает yql-запрос, который извлекает из hit-log (данные за день) пары домен + счетчик
 * и пишет их в статическую таблицу, все строчки которой потом будут записаны
 * в общую дин таблицу джобой [PopulateCountersByHitLogDynTableJob]
 * Insert данных в статическую таблицу происходит прямо в yql-запросе `counterbydomain/ParseHitLog.sql`
 */
@JugglerCheck(
    ttl = JugglerCheck.Duration(hours = 6),
    needCheck = ProductionOnly::class,
    notifications = [OnChangeNotification(
        recipient = [NotificationRecipient.CHAT_API_CLEAN_MONITORING],
        method = [NotificationMethod.TELEGRAM],
        status = [JugglerStatus.OK, JugglerStatus.CRIT]
    )],
    tags = [CheckTag.DIRECT_PRIORITY_1_NOT_READY]
)
@Hourglass(cronExpression = "0 0 */3 * * ?", needSchedule = ProductionOnly::class)
class ParseHitLogsJob(
    directConfig: DirectConfig,
    ytProvider: YtProvider,
    ppcPropertiesSupport: PpcPropertiesSupport
) : ExecuteYQLAndExportDataJob(
    directConfig,
    ytProvider,
    ppcPropertiesSupport.get(PpcPropertyNames.PARSE_HIT_LOG_CLUSTER),
    ppcPropertiesSupport.get(PpcPropertyNames.PARSE_HIT_LOG_LAST_READ_TIME),
    "counterbydomain/ParseHitLog.sql"
) {
    override fun getSourceTablesPathTemplate() = listOf("//logs/hit-log/1d/%s", "//logs/hit-private-log/1d/%s")

    override fun getConfigBranch() = COUNTERS_BY_DOMAIN_HIT_LOG_CONFIG_BRANCH

    override fun getOutputTablesFolder() = PARSED_LOG_FOLDER
}
