package ru.yandex.direct.jobs.counterbydomain;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod;
import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.common.db.PpcPropertyNames;
import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.jobs.yt.ExecuteYQLAndExportDataJob;
import ru.yandex.direct.juggler.JugglerStatus;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification;
import ru.yandex.direct.juggler.check.model.NotificationRecipient;
import ru.yandex.direct.scheduler.Hourglass;
import ru.yandex.direct.ytwrapper.client.YtProvider;

import static ru.yandex.direct.jobs.counterbydomain.CounterByDomainUtils.COUNTERS_BY_DOMAIN_CONFIG_BRANCH;
import static ru.yandex.direct.jobs.counterbydomain.CounterByDomainUtils.PARSED_LOG_FOLDER;
import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_1_NOT_READY;

/**
 * Запускает yql-запрос, который извлекает из bs-watch-log (данные за день) пары домен + счетчик,
 * удовлетворяющих условиям:
 * <li> людей на счетчике должно быть хотя бы 10% от людей на домене;</li>
 * <li> хотя бы 10 уникальных людей на домене</li>
 * и пишет их в статическую таблицу, все строчки которой потом будут записаны в общую дин таблицу
 * джобой {@link PopulateCountersDynTableJob}
 * Insert данных в статическую таблицу происходит прямо в yql-запросе {@code counterbydomain/ParseWatchLog.sql}
 */
@JugglerCheck(
        ttl = @JugglerCheck.Duration(hours = 9),
        needCheck = ProductionOnly.class,
        notifications = @OnChangeNotification(
                recipient = {NotificationRecipient.CHAT_API_CLEAN_MONITORING, NotificationRecipient.LOGIN_GERDLER},
                method = NotificationMethod.TELEGRAM,
                status = {JugglerStatus.OK, JugglerStatus.CRIT}
        ),
        //PRIORITY: Временно поставили приоритет по умолчанию; maxlog
        tags = {DIRECT_PRIORITY_1_NOT_READY})
@Hourglass(cronExpression = "0 0 */6 * * ?", needSchedule = ProductionOnly.class)
public class ParseWatchLogsJob extends ExecuteYQLAndExportDataJob {
    @Autowired
    public ParseWatchLogsJob(
            DirectConfig directConfig,
            YtProvider ytProvider,
            PpcPropertiesSupport ppcPropertiesSupport
    ) {
        super(
                directConfig,
                ytProvider,
                ppcPropertiesSupport.get(PpcPropertyNames.PARSE_WATCH_LOG_CLUSTER),
                ppcPropertiesSupport.get(PpcPropertyNames.PARSE_WATCH_LOG_LAST_READ_TIME),
                "counterbydomain/ParseWatchLog.sql"
        );
    }

    @Override
    protected List<String> getSourceTablesPathTemplate() {
        return List.of("//logs/bs-watch-log/1d/%s");
    }

    @Override
    protected String getConfigBranch() {
        return COUNTERS_BY_DOMAIN_CONFIG_BRANCH;
    }

    @Override
    protected String getOutputTablesFolder() {
        return PARSED_LOG_FOLDER;
    }
}
