package ru.yandex.direct.jobs.counterbydomain

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.db.PpcPropertyNames
import ru.yandex.direct.config.DirectConfig
import ru.yandex.direct.env.ProductionOnly
import ru.yandex.direct.jobs.counterbydomain.CounterByDomainUtils.COUNTERS_BY_DOMAIN_HIT_LOG_CONFIG_BRANCH
import ru.yandex.direct.jobs.counterbydomain.CounterByDomainUtils.PARSED_LOG_FOLDER
import ru.yandex.direct.jobs.counterbydomain.CounterByDomainUtils.TARGET_COUNTERS_HIT_LOG_TABLE
import ru.yandex.direct.jobs.counterbydomain.CounterByDomainUtils.TARGET_TABLE_CLUSTER
import ru.yandex.direct.jobs.yt.PopulateDynTableJob
import ru.yandex.direct.juggler.JugglerStatus
import ru.yandex.direct.juggler.check.annotation.JugglerCheck
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification
import ru.yandex.direct.juggler.check.model.CheckTag
import ru.yandex.direct.juggler.check.model.NotificationRecipient
import ru.yandex.direct.scheduler.Hourglass
import ru.yandex.direct.ytwrapper.client.YtProvider
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode

/**
 * Джоба перекладывает данные из статических таблиц, собранных [ParseHitLogsJob], в одну
 * общую динамическую таблицу
 */
@JugglerCheck(
    ttl = JugglerCheck.Duration(hours = 3, minutes = 5),
    needCheck = ProductionOnly::class,
    notifications = [OnChangeNotification(
        recipient = [NotificationRecipient.CHAT_API_CLEAN_MONITORING],
        method = [NotificationMethod.TELEGRAM],
        status = [JugglerStatus.OK, JugglerStatus.CRIT])],
    tags = [CheckTag.DIRECT_PRIORITY_1_NOT_READY]
)
@Hourglass(periodInSeconds = 60 * 60, needSchedule = ProductionOnly::class)
class PopulateCountersByHitLogDynTableJob(
    directConfig: DirectConfig?,
    ytProvider: YtProvider?,
    ppcPropertiesSupport: PpcPropertiesSupport
) : PopulateDynTableJob(
    directConfig,
    ytProvider,
    ppcPropertiesSupport.get(PpcPropertyNames.PARSE_HIT_LOG_POPULATE_DYN_TABLE_JOB_ENABLED)
) {
    override fun getConfigBranch() = COUNTERS_BY_DOMAIN_HIT_LOG_CONFIG_BRANCH

    override fun getTargetTable() = TARGET_COUNTERS_HIT_LOG_TABLE

    override fun getParsedLogFolder() = PARSED_LOG_FOLDER

    override fun getTargetTableCluster() = TARGET_TABLE_CLUSTER

    public override fun convertRow(node: YTreeMapNode, timestamp: Long): YTreeMapNode {
        val builder = YTree.mapBuilder()
        builder.key("domain").value(node.getStringO("domain").orElse(""))
        builder.key("counter_id").value(node.getLong("counter_id"))
        builder.key("num_counter_users").value(node.getLong("num_counter_users"))
        builder.key("num_domain_users").value(node.getLong("num_domain_users"))
        builder.key("num_domains_on_counter").value(node.getLong("num_domains_on_counter"))
        builder.key("num_significant_domains_on_counter").value(node.getLong("num_significant_domains_on_counter"))
        builder.key("black_list_result").value(node.getString("black_list_result"))
        builder.key("markup_result").value(node.getString("markup_result"))
        builder.key("owner_uid").value(node.getLong("owner"))
        builder.key("timestamp").value(timestamp)
        return builder.buildMap()
    }
}
