package ru.yandex.direct.jobs.counterbydomain;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod;
import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.common.db.PpcPropertyNames;
import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.jobs.yt.PopulateDynTableJob;
import ru.yandex.direct.juggler.JugglerStatus;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification;
import ru.yandex.direct.juggler.check.model.NotificationRecipient;
import ru.yandex.direct.scheduler.Hourglass;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.model.YtCluster;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTreeBuilder;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;

import static ru.yandex.direct.jobs.counterbydomain.CounterByDomainUtils.COUNTERS_BY_DOMAIN_CONFIG_BRANCH;
import static ru.yandex.direct.jobs.counterbydomain.CounterByDomainUtils.PARSED_LOG_FOLDER;
import static ru.yandex.direct.jobs.counterbydomain.CounterByDomainUtils.TARGET_COUNTERS_TABLE;
import static ru.yandex.direct.jobs.counterbydomain.CounterByDomainUtils.TARGET_TABLE_CLUSTER;
import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_1_NOT_READY;

/**
 * Джоба перекладывает данные из статических таблиц, собранных {@link ParseWatchLogsJob}, в одну
 * общую динамическую таблицу
 */
@JugglerCheck(
        ttl = @JugglerCheck.Duration(hours = 3, minutes = 5),
        needCheck = ProductionOnly.class,
        notifications = @OnChangeNotification(
                recipient = {NotificationRecipient.CHAT_API_CLEAN_MONITORING, NotificationRecipient.LOGIN_GERDLER},
                method = NotificationMethod.TELEGRAM,
                status = {JugglerStatus.OK, JugglerStatus.CRIT}
        ),
        //PRIORITY: Временно поставили приоритет по умолчанию; maxlog
        tags = {DIRECT_PRIORITY_1_NOT_READY})
@Hourglass(periodInSeconds = 60 * 60, needSchedule = ProductionOnly.class)
public class PopulateCountersDynTableJob extends PopulateDynTableJob {

    @Override
    protected String getConfigBranch() {
        return COUNTERS_BY_DOMAIN_CONFIG_BRANCH;
    }

    @Override
    protected String getTargetTable() {
        return TARGET_COUNTERS_TABLE;
    }

    @Override
    protected String getParsedLogFolder() {
        return PARSED_LOG_FOLDER;
    }

    @Override
    protected YtCluster getTargetTableCluster() {
        return TARGET_TABLE_CLUSTER;
    }

    @Autowired
    public PopulateCountersDynTableJob(
            DirectConfig directConfig,
            YtProvider ytProvider,
            PpcPropertiesSupport ppcPropertiesSupport
    ) {
        super(directConfig, ytProvider,
                ppcPropertiesSupport.get(PpcPropertyNames.PARSE_WATCH_LOG_POPULATE_DYN_TABLE_JOB_ENABLED));
    }

    @Override
    public YTreeMapNode convertRow(YTreeMapNode node, Long timestamp) {
        YTreeBuilder builder = YTree.mapBuilder();
        builder.key("domain").value(node.getStringO("domain").orElse(""));
        builder.key("counter_id").value(node.getLong("counter_id"));
        builder.key("owner_uid").value(node.getLong("owner"));
        builder.key("timestamp").value(timestamp);
        return builder.buildMap();
    }
}
