package ru.yandex.direct.jobs.crm;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.juggler.JugglerStatus;
import ru.yandex.direct.rbac.PpcRbac;
import ru.yandex.direct.scheduler.support.DirectJob;

import static ru.yandex.direct.core.entity.ppcproperty.model.PpcPropertyEnum.ENABLE_LIMITED_SUPPORT_READ_ALL_CLIENTS_META;

/**
 * Проверяет, включен ли fallback-режим пинкодного доступа для limited support
 * В нормальном режиме саппорты получают доступ к клиентам через пинкодницу
 * Если этот режим перестает работать, включается fallback-режим,
 * в котором у limited support есть доступ ко всем клиентам
 */
// Включим, когда включенный Fallback перестанет быть нормой (DIRECT-154763)
//@JugglerCheck(
//        ttl = @JugglerCheck.Duration(minutes = 30 + 1),
//        tags = {DIRECT_PRIORITY_1},
//        needCheck = ProductionOnly.class,
//        notifications = @OnChangeNotification(
//                method = NotificationMethod.TELEGRAM,
//                recipient = NotificationRecipient.CHAT_INTERNAL_SYSTEMS_MONITORING,
//                status = {JugglerStatus.OK, JugglerStatus.CRIT}
//        )
//)
//@JugglerCheck(
//        ttl = @JugglerCheck.Duration(minutes = 30),
//        tags = {DIRECT_PRIORITY_1},
//        needCheck = TestingOnly.class
//)
//@Hourglass(periodInSeconds = 60 * 10, needSchedule = NonDevelopmentEnvironment.class)
public class CheckPincodeAccessFallbackModeJob extends DirectJob {

    private final PpcRbac ppcRbac;
    private final PpcPropertiesSupport ppcPropertiesSupport;

    @Autowired
    public CheckPincodeAccessFallbackModeJob(PpcRbac ppcRbac, PpcPropertiesSupport ppcPropertiesSupport) {
        this.ppcRbac = ppcRbac;
        this.ppcPropertiesSupport = ppcPropertiesSupport;
    }

    @Override
    public void execute() {
        boolean fallbackEnabled = ppcRbac.canLimitedSupportReadAllClients();
        if (fallbackEnabled) {
            String meta = ppcPropertiesSupport.get(ENABLE_LIMITED_SUPPORT_READ_ALL_CLIENTS_META.getName());
            setJugglerStatus(
                    JugglerStatus.CRIT,
                    String.format("Fallback access mode for limited support enabled. Info: %s", meta));
        } else {
            setJugglerStatus(JugglerStatus.OK, "Fallback access mode for limited support disabled");
        }
    }
}
