package ru.yandex.direct.jobs.crypta

import ru.yandex.direct.core.entity.crypta.model.CaCryptaSegment
import ru.yandex.direct.core.entity.crypta.model.CaCryptaSegmentExport
import ru.yandex.direct.core.entity.retargeting.model.CryptaGoalScope
import ru.yandex.direct.core.entity.retargeting.model.CryptaInterestType
import ru.yandex.direct.core.entity.retargeting.model.Goal

internal object CryptaSegmentsConverter {

    fun convertGoalsToSegments(goals: Collection<Goal>): Set<CaCryptaSegmentExport> =
        goals.flatMap(this::convertGoalToSegments).toSet()

    private fun convertGoalToSegments(goal: Goal): List<CaCryptaSegmentExport> {
        val longTermSegment = CaCryptaSegmentExport()
            .withKeywordId(goal.keyword?.toIntOrNull())
            .withSegmentId(goal.keywordValue?.toIntOrNull())

        if (goal.keywordShort != null && goal.keywordValueShort != null) {
            val shortTermSegment = CaCryptaSegmentExport()
                .withKeywordId(goal.keywordShort.toIntOrNull())
                .withKeywordId(goal.keywordValueShort.toIntOrNull())

            return listOf(longTermSegment, shortTermSegment)
        }

        return listOf(longTermSegment)
    }

    fun convertYtDataToGoal(cryptaSegment: CaCryptaSegment, id: Long): Goal? {
        if (cryptaSegment.exports.isNullOrEmpty()) {
            return null
        }

        cryptaSegment.exports.sortBy { it.keywordId }
        var name = cryptaSegment.names.find { it.language == "ru" }?.name
        if (name == null) {
            name = cryptaSegment.names.firstOrNull()?.name
        }

        //все интересы в директе должны иметь краткосрочный сегмент
        val shortTermSegment = cryptaSegment.exports.elementAtOrElse(1) { cryptaSegment.exports[0] }

        return Goal()
            .withId(id)
            .withKeyword(cryptaSegment.exports[0].keywordId.toString())
            .withKeywordValue(cryptaSegment.exports[0].segmentId.toString())
            .withKeywordShort(shortTermSegment?.keywordId?.toString())
            .withKeywordValueShort(shortTermSegment?.segmentId?.toString())
            .withName(name)
            .withTankerNameKey(cryptaSegment.tankerNameKey)
            .withTankerDescriptionKey(cryptaSegment.tankerDescriptionKey)
            .withCryptaScope(convertCryptaCampaignTypesToScope(cryptaSegment.campaignTypes))
            .withInterestType(CryptaInterestType.all)
            .withTankerAudienceTypeKey(cryptaSegment.tankerSegmentTypeKey)
                as Goal
    }

    private fun convertCryptaCampaignTypesToScope(values: List<String>) =
        values.map { CryptaGoalScope.fromTypedValue(it) }.toSet()
}
