package ru.yandex.direct.jobs.directdb;

import java.time.LocalDate;

import javax.annotation.ParametersAreNonnullByDefault;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.jobs.configuration.DirectExportYtClustersParametersSource;
import ru.yandex.direct.jobs.directdb.service.HomeDirectDbResamplingService;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.scheduler.Hourglass;
import ru.yandex.direct.scheduler.support.DirectParameterizedJob;
import ru.yandex.direct.scheduler.support.ParameterizedBy;
import ru.yandex.direct.ytwrapper.model.YtCluster;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_2;

@ParametersAreNonnullByDefault
@JugglerCheck(ttl = @JugglerCheck.Duration(hours = 6), needCheck = ProductionOnly.class, tags = {DIRECT_PRIORITY_2})
@ParameterizedBy(parametersSource = DirectExportYtClustersParametersSource.class)
@Hourglass(cronExpression = "0 15 4-23 * * ?")
public class HomeDirectDbResamplingJob extends DirectParameterizedJob<YtCluster> {

    private static final Logger logger = LoggerFactory.getLogger(HomeDirectDbResamplingJob.class);

    private final HomeDirectDbResamplingService resamplingService;
    private final DirectExportYtClustersParametersSource parametersSource;

    public HomeDirectDbResamplingJob(HomeDirectDbResamplingService resamplingService,
                                     DirectExportYtClustersParametersSource parametersSource) {
        this.resamplingService = resamplingService;
        this.parametersSource = parametersSource;
    }

    @Override
    public void execute() {
        logger.info("HomeDirectDbResamplingJob started");
        resamplingService.resample(LocalDate.now(), parametersSource.convertStringToParam(getParam()));
        logger.info("HomeDirectDbResamplingJob finished");
    }

    @Override
    public void onShutdown() {
        resamplingService.shutdown();
    }
}

