package ru.yandex.direct.jobs.directdb.model;

import java.time.LocalDate;
import java.time.LocalDateTime;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

@ParametersAreNonnullByDefault
public class Operation {
    public enum OperationStatus {
        IN_PROGRESS,
        DONE,
        ERROR
    }
    private String name;

    private LocalDateTime start;
    private LocalDateTime finish;
    private LocalDate date;
    private String operationId;
    private OperationStatus status;
    private int attempts;
    private String errorMessage;

    @SuppressWarnings("squid:S00107")
    public Operation(String name,
                     LocalDateTime start,
                     @Nullable LocalDateTime finish,
                     LocalDate date,
                     String operationId,
                     OperationStatus status,
                     int attempts,
                     @Nullable
                     String errorMessage) {
        this.name = name;
        this.start = start;
        this.finish = finish;
        this.date = date;
        this.operationId = operationId;
        this.status = status;
        this.attempts = attempts;
        this.errorMessage = errorMessage;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LocalDateTime getStart() {
        return start;
    }

    public void setStart(LocalDateTime start) {
        this.start = start;
    }

    public LocalDateTime getFinish() {
        return finish;
    }

    public void setFinish(LocalDateTime finish) {
        this.finish = finish;
    }

    public LocalDate getDate() {
        return date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public String getOperationId() {
        return operationId;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public OperationStatus getStatus() {
        return status;
    }

    public void setStatus(OperationStatus status) {
        this.status = status;
    }

    public int getAttempts() {
        return attempts;
    }

    public void setAttempts(int attempts) {
        this.attempts = attempts;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Override
    public String toString() {
        // errorMessage очень большой, если он не null, и в логах не очень то и нужен,
        // так как в любом случае сохраняется в мета-таблице operations. Если нужен в логе, то лучше вывести независимо.
        return ReflectionToStringBuilder.toStringExclude(this, "errorMessage");
    }
}
