package ru.yandex.direct.jobs.directdb.model;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

@ParametersAreNonnullByDefault
public class SnapshotAttributes {
    private String cypressPath;
    private boolean finished;

    public SnapshotAttributes(String cypressPath, boolean finished) {
        this.cypressPath = cypressPath;
        this.finished = finished;
    }

    public String getCypressPath() {
        return cypressPath;
    }

    public void setCypressPath(String cypressPath) {
        this.cypressPath = cypressPath;
    }

    public boolean isFinished() {
        return finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SnapshotAttributes that = (SnapshotAttributes) o;
        return finished == that.finished &&
                Objects.equals(cypressPath, that.cypressPath);
    }

    @Override
    public int hashCode() {
        return Objects.hash(cypressPath, finished);
    }
}
