package ru.yandex.direct.jobs.export.feature.diff

import ru.yandex.direct.ytwrapper.model.YtField
import ru.yandex.direct.ytwrapper.model.YtTableRow

private val ID = YtField("feature_id", Long::class.java)
private val TEXT_ID = YtField("feature_text_id", String::class.java)
private val NAME = YtField("feature_public_name", String::class.java)
private val PERCENT = YtField("percent", Int::class.java)
private val LOGIN_TO_SET_PERCENT = YtField("login", String::class.java)
private val OWNER = YtField("owner", String::class.java)
private val TICKET_ID = YtField("ticket_id", String::class.java)

class FeatureYtTableRow(
    fields: List<YtField<*>> = listOf(ID, TEXT_ID, NAME, PERCENT, LOGIN_TO_SET_PERCENT, OWNER, TICKET_ID)
) : YtTableRow(fields) {

    val id: Long get() = valueOf(ID)

    val textId: String get() = valueOf(TEXT_ID)

    val name: String get() = valueOf(NAME)

    val percent: Int get() = valueOf(PERCENT)

    val login: String? get() = valueOf(LOGIN_TO_SET_PERCENT)

    val owner: String? get() = valueOf(OWNER)

    val ticketId: String? get() = valueOf(TICKET_ID)
}
