package ru.yandex.direct.jobs.export.feature.diff

import ru.yandex.direct.tracing.Trace
import ru.yandex.direct.ytwrapper.client.YtProvider
import ru.yandex.direct.ytwrapper.model.YtCluster
import ru.yandex.direct.ytwrapper.model.YtOperator
import ru.yandex.direct.ytwrapper.model.YtTable
import ru.yandex.direct.ytwrapper.utils.FreshestClusterFinder

internal object Utils {
    private const val FEATURES_EXPORT_PATH = "export/chassis/features"
    private val CLUSTERS = listOf(YtCluster.HAHN, YtCluster.ARNOLD)

    const val ZERO_PERCENT: Int = 0
    const val ONE_HUNDRED_PERCENT: Int = 100

    val PROD_YT_TABLE = YtTable("//home/direct/$FEATURES_EXPORT_PATH")

    fun chooseFreshestCluster(ytProvider: YtProvider): YtCluster {
        return FreshestClusterFinder.getFreshestCluster(ytProvider, PROD_YT_TABLE, CLUSTERS)
    }

    fun resolveTsTable(cluster: YtCluster): YtTable {
        return when (cluster) {
            YtCluster.ARNOLD -> YtTable("//home/direct-dev/$FEATURES_EXPORT_PATH")
            else -> YtTable("//home/direct/test/$FEATURES_EXPORT_PATH")
        }
    }

    fun readFeatureTable(ytOperator: YtOperator, ytTable: YtTable): MutableMap<String, FeatureRow> {
        Trace.current().profile("read_feature:yql").use {
            val featureMap: MutableMap<String, FeatureRow> = mutableMapOf()
            ytOperator.readTable(ytTable, FeatureYtTableRow()) { row: FeatureYtTableRow ->
                fillFeatureMap(row, featureMap)
            }
            return featureMap
        }
    }

    private fun fillFeatureMap(row: FeatureYtTableRow, featureMap: MutableMap<String, FeatureRow>) {
        featureMap[row.textId] = FeatureRow(
            id = row.id, textId = row.textId, name = row.name,
            percent = row.percent, login = row.login, owner = row.owner, ticketId = row.ticketId
        )
    }
}
