package ru.yandex.direct.jobs.featureschanges;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

import ru.yandex.direct.jobs.featureschanges.model.ClientsFeaturesChangesLogData;
import ru.yandex.direct.jobs.featureschanges.model.FeaturesChangesLogDataBase;
import ru.yandex.direct.jobs.featureschanges.model.FeaturesHistoryChangesLogData;

import static java.util.Collections.emptyList;

public class FeaturesChangesLogFilterHelper {

    private FeaturesChangesLogFilterHelper() {
    }

    public static Optional<FeaturesHistoryChangesLogData> getFirstUnprocessedLogData(
            List<FeaturesHistoryChangesLogData> logDataList,
            String lastUniqueId) {

        logDataList = filterByLastUniqueId(logDataList, lastUniqueId);

        return logDataList.stream().findFirst();
    }

    /**
     * Для событий таблицы clients_features: оставляем первые подряд идущие записи, которые будут относиться к одному
     * тикету (одной фиче).
     */
    public static List<ClientsFeaturesChangesLogData> filterFirstItemsByOneTicket(
            List<ClientsFeaturesChangesLogData> logDataList,
            String lastUniqueId) {

        logDataList = filterByLastUniqueId(logDataList, lastUniqueId);

        if (logDataList.isEmpty()) {
            return emptyList();
        }

        Long firstFeatureId = logDataList.get(0).getFeatureId();
        List<ClientsFeaturesChangesLogData> firstItems = new ArrayList<>();
        for (ClientsFeaturesChangesLogData logData : logDataList) {
            Long currentFeatureId = logData.getFeatureId();
            if (!firstFeatureId.equals(currentFeatureId)) {
                break;
            }
            firstItems.add(logData);
        }
        return firstItems;
    }

    /**
     * Отбрасываем все события, которые были до lastUniqueId (включая событие с lastUniqueId).
     *
     * @param logDataList  - список событий
     * @param lastUniqueId - уникальный идентификатор последнего обработанного события.
     * @return - отфильтрованный список событий
     */
    private static <T extends FeaturesChangesLogDataBase> List<T> filterByLastUniqueId(
            List<T> logDataList,
            String lastUniqueId) {

        // Нужно определить позицию не первого, а последнего элемента соответствующего lastUniqueId.
        // Иначе может произойти зацикливание джобы.
        int lastHandledIndex = -1;
        for (int i = logDataList.size() - 1; i >= 0; i--) {
            FeaturesChangesLogDataBase logData = logDataList.get(i);
            if (lastUniqueId.equals(logData.getUniqueId())) {
                lastHandledIndex = i;
                break;
            }
        }

        int fromIndex = lastHandledIndex + 1;
        int toIndex = logDataList.size();

        return logDataList.subList(fromIndex, toIndex);
    }

}
