package ru.yandex.direct.jobs.featureschanges.exception;

public class TicketNotFound extends RuntimeException {

    private static final String MSG = "Ticket for feature %s not found";

    private final String featureTextId;

    public TicketNotFound(String featureTextId) {
        super(String.format(MSG, featureTextId));
        this.featureTextId = featureTextId;
    }

    public String getFeatureTextId() {
        return featureTextId;
    }
}
