package ru.yandex.direct.jobs.featureschanges.handlers;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.feature.repository.FeatureHistoryRepository;
import ru.yandex.direct.core.entity.feature.repository.FeatureRepository;
import ru.yandex.direct.core.entity.user.service.UserService;
import ru.yandex.direct.jobs.featureschanges.FeaturesLogStartrekService;
import ru.yandex.direct.jobs.featureschanges.model.ClientsFeaturesChangesLogData;
import ru.yandex.direct.jobs.featureschanges.model.FeaturesChangesSqlOperationType;
import ru.yandex.direct.jobs.featureschanges.model.FeaturesHistoryChangesLogData;

@Component
public class FeaturesChangesLogHandlerFactory {

    private static final Logger logger = LoggerFactory.getLogger(FeaturesChangesLogHandlerFactory.class);
    private final FeaturesLogStartrekService startrekService;
    private final FeatureRepository featureRepository;
    private final FeatureHistoryRepository featureHistoryRepository;
    private final UserService userService;

    @Autowired
    public FeaturesChangesLogHandlerFactory(FeaturesLogStartrekService startrekService,
                                            FeatureRepository featureRepository,
                                            FeatureHistoryRepository featureHistoryRepository,
                                            UserService userService) {
        this.startrekService = startrekService;
        this.featureRepository = featureRepository;
        this.featureHistoryRepository = featureHistoryRepository;
        this.userService = userService;
    }

    public FeaturesChangesLogHandler createClientsFeaturesHandler(List<ClientsFeaturesChangesLogData> logDataList) {
        return new ClientsFeaturesAllLogHandler(logDataList, startrekService, featureRepository, userService);
    }

    public FeaturesChangesLogHandler createFeaturesHistoryHandler(FeaturesHistoryChangesLogData logData) {


        FeaturesChangesSqlOperationType sqlOperationType = logData.getSqlOperationType();

        switch (sqlOperationType) {
            case DELETE:
                return new FeaturesHistoryDeleteLogHandler(logData, startrekService);
            case INSERT:
                return new FeaturesHistoryInsertLogHandler(logData, startrekService, featureRepository);
            case UPDATE:
                return new FeaturesHistoryUpdateLogHandler(logData, startrekService, featureHistoryRepository,
                        featureRepository);
            default:
                return () -> logger.warn("Unknown type for {}", logData);
        }

    }
}
