package ru.yandex.direct.jobs.featureschanges.handlers;

import ru.yandex.direct.jobs.featureschanges.FeaturesLogStartrekService;
import ru.yandex.direct.jobs.featureschanges.exception.TicketNotFound;
import ru.yandex.direct.jobs.featureschanges.model.FeaturesHistoryChangesLogData;

public class FeaturesHistoryDeleteLogHandler implements FeaturesChangesLogHandler {

    private final FeaturesHistoryChangesLogData logData;
    private final FeaturesLogStartrekService startrekService;

    public FeaturesHistoryDeleteLogHandler(FeaturesHistoryChangesLogData logData,
                                           FeaturesLogStartrekService startrekService) {
        this.logData = logData;
        this.startrekService = startrekService;
    }

    @Override
    public void handle() {
        String featureTextId = logData.getFeatureTextId();
        String ticketKey = startrekService.getTicketKey(featureTextId);

        if (ticketKey == null) {
            throw new TicketNotFound(featureTextId);
        }

        startrekService.closeTicket(ticketKey, "Фича удалена из базы данных");
    }
}
