package ru.yandex.direct.jobs.featureschanges.handlers;

import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.core.entity.feature.model.FeatureSettings;
import ru.yandex.direct.core.entity.feature.repository.FeatureRepository;
import ru.yandex.direct.jobs.featureschanges.FeaturesLogStartrekService;
import ru.yandex.direct.jobs.featureschanges.model.FeaturesHistoryChangesLogData;
import ru.yandex.direct.utils.JsonUtils;

import static org.apache.commons.collections4.SetUtils.emptyIfNull;
import static ru.yandex.direct.dbschema.ppcdict.tables.FeaturesHistory.FEATURES_HISTORY;

public class FeaturesHistoryInsertLogHandler implements FeaturesChangesLogHandler {

    private static final Logger logger = LoggerFactory.getLogger(FeaturesHistoryInsertLogHandler.class);
    private final FeaturesHistoryChangesLogData logData;
    private final FeatureRepository featureRepository;
    private final FeaturesLogStartrekService startrekService;

    public FeaturesHistoryInsertLogHandler(FeaturesHistoryChangesLogData logData,
                                           FeaturesLogStartrekService startrekService,
                                           FeatureRepository featureRepository) {
        this.logData = logData;
        this.startrekService = startrekService;
        this.featureRepository = featureRepository;
    }


    @Override
    public void handle() {
        FeatureSettings featureSettings = getFeatureSettings();
        String owner = featureSettings.getOriginalOwner();
        Set<String> watchers = emptyIfNull(featureSettings.getOriginalWatchers());

        if (owner == null) {
            logger.warn("Can't create ticket. Owner is null for {}", logData);
            return;
        }

        String featureTextId = logData.getFeatureTextId();
        String ticketId = startrekService.createMainTicket(featureTextId, owner, watchers);
        featureRepository.updateTicketId(featureTextId, ticketId);
    }

    private FeatureSettings getFeatureSettings() {
        String settings = logData.getNameToValue().get(FEATURES_HISTORY.NEW_SETTINGS.getName());
        return JsonUtils.fromJson(settings, FeatureSettings.class);
    }
}
