package ru.yandex.direct.jobs.featureschanges.model;

import java.time.LocalDateTime;

import ru.yandex.direct.dbutil.model.ClientId;

import static ru.yandex.direct.jobs.featureschanges.model.FeaturesChangesSqlOperationType.UNKNOWN;

public class ClientsFeaturesChangesLogData extends FeaturesChangesLogDataBase {
    private final String isEnabled;
    private final ClientId clientId;
    private final Long featureId;
    private final Long reqId;


    public ClientsFeaturesChangesLogData(LocalDateTime dateTime, FeaturesChangesSqlOperationType sqlOperationType,
                                         String isEnabled, ClientId clientId, Long featureId, Long reqId,
                                         String uniqueId, String method) {
        this(dateTime, sqlOperationType, isEnabled, clientId, featureId, reqId, uniqueId, method, false);
    }

    public ClientsFeaturesChangesLogData(LocalDateTime dateTime, FeaturesChangesSqlOperationType sqlOperationType,
                                         String isEnabled, ClientId clientId, Long featureId, Long reqId,
                                         String uniqueId, String method, boolean isBrokenData) {

        super(dateTime, sqlOperationType, uniqueId, isBrokenData, method);
        this.isEnabled = isEnabled;
        this.clientId = clientId;
        this.featureId = featureId;
        this.reqId = reqId;
    }

    public static ClientsFeaturesChangesLogData createInvalidLogData(LocalDateTime dateTime, String uniqueId) {
        return new ClientsFeaturesChangesLogData(
                dateTime, UNKNOWN, "0", ClientId.fromLong(-1L), -1L, -1L, uniqueId, null, true);
    }

    public ClientId getClientId() {
        return clientId;
    }

    public Long getFeatureId() {
        return featureId;
    }

    public String getIsEnabled() {
        return isEnabled;
    }

    public Long getReqId() {
        return reqId;
    }

    @Override
    public String toString() {
        return "ClientsFeaturesChangesLogData{" +
                "isEnabled='" + isEnabled + '\'' +
                ", clientId=" + clientId +
                ", featureId=" + featureId +
                ", reqId=" + reqId +
                "} " + super.toString();
    }
}
