package ru.yandex.direct.jobs.featureschanges.model;

import java.time.LocalDateTime;

import javax.annotation.Nullable;

public abstract class FeaturesChangesLogDataBase {
    private final LocalDateTime dateTime;
    private final FeaturesChangesSqlOperationType sqlOperationType;
    private final String uniqueId;
    private final boolean isBrokenData;
    private String login;

    protected FeaturesChangesLogDataBase(LocalDateTime dateTime, FeaturesChangesSqlOperationType sqlOperationType,
                                         String uniqueId, boolean isBrokenData) {

        this(dateTime, sqlOperationType, uniqueId, isBrokenData, null);
    }

    protected FeaturesChangesLogDataBase(LocalDateTime dateTime, FeaturesChangesSqlOperationType sqlOperationType,
                                      String uniqueId, boolean isBrokenData, String login) {
        this.dateTime = dateTime;
        this.sqlOperationType = sqlOperationType;
        this.uniqueId = uniqueId;
        this.isBrokenData = isBrokenData;
        this.login = login;
    }

    public LocalDateTime getDateTime() {
        return dateTime;
    }

    public FeaturesChangesSqlOperationType getSqlOperationType() {
        return sqlOperationType;
    }

    public String getUniqueId() {
        return uniqueId;
    }

    public boolean isBrokenData() {
        return isBrokenData;
    }

    @Nullable
    public String getLogin() {
        return login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    @Override
    public String toString() {
        return "FeaturesChangesLogDataBase{" +
                "dateTime=" + dateTime +
                ", sqlOperationType=" + sqlOperationType +
                ", uniqueId='" + uniqueId + '\'' +
                ", isBrokenData=" + isBrokenData +
                ", login='" + login + '\'' +
                '}';
    }
}
