package ru.yandex.direct.jobs.featureschanges.model;

import java.time.LocalDateTime;
import java.util.Map;

import static java.util.Collections.emptyMap;
import static ru.yandex.direct.jobs.featureschanges.model.FeaturesChangesSqlOperationType.UNKNOWN;

public class FeaturesHistoryChangesLogData extends FeaturesChangesLogDataBase {
    private final Map<String, String> nameToValue;
    private final Long featuresHistoryId;
    private final String featureTextId;
    private final Long operatorUid;


    public FeaturesHistoryChangesLogData(LocalDateTime dateTime, FeaturesChangesSqlOperationType sqlOperationType,
                                         Map<String, String> nameToValue, Long featuresHistoryId,
                                         String featureTextId, Long operatorUid, String uniqueId) {
        this(dateTime, sqlOperationType, nameToValue, featuresHistoryId, featureTextId, operatorUid, uniqueId, false);
    }

    public FeaturesHistoryChangesLogData(LocalDateTime dateTime, FeaturesChangesSqlOperationType sqlOperationType,
                                         Map<String, String> nameToValue, Long featuresHistoryId, String featureTextId,
                                         Long operatorUid, String uniqueId, boolean isBrokenData) {

        super(dateTime, sqlOperationType, uniqueId, isBrokenData);
        this.nameToValue = nameToValue;
        this.featuresHistoryId = featuresHistoryId;
        this.featureTextId = featureTextId;
        this.operatorUid = operatorUid;
    }

    public static FeaturesHistoryChangesLogData createInvalidLogData(LocalDateTime dateTime, String uniqueId) {
        return new FeaturesHistoryChangesLogData(dateTime, UNKNOWN, emptyMap(), -1L, "", -1L, uniqueId, true);
    }

    public String getFeatureTextId() {
        return featureTextId;
    }

    public Map<String, String> getNameToValue() {
        return nameToValue;
    }

    public Long getOperatorUid() {
        return operatorUid;
    }

    public Long getFeaturesHistoryId() {
        return featuresHistoryId;
    }

    @Override
    public String toString() {
        return "FeaturesHistoryChangesLogData{" +
                "nameToValue=" + nameToValue +
                ", featuresHistoryId=" + featuresHistoryId +
                ", featureTextId='" + featureTextId + '\'' +
                ", operatorUid=" + operatorUid +
                "} " + super.toString();
    }
}
