package ru.yandex.direct.jobs.fetchmobilecontentfromstore;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

import org.apache.commons.collections4.MapUtils;

import ru.yandex.direct.common.mobilecontent.MobileContentStoreType;
import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.core.entity.mobilecontent.model.OsType;
import ru.yandex.direct.ytwrapper.model.YtCluster;

import static ru.yandex.direct.core.entity.mobilecontent.service.MobileContentServiceConstants.OS_TYPE_TO_YT_PATH;

/**
 * Конфиг для джобы FetchMobileContentFromStoreJob.
 */
class FetchMobileContentFromStoreJobConfig {

    private static final Map<String, OsType> YT_PATH_TO_OS_TYPE = MapUtils.invertMap(OS_TYPE_TO_YT_PATH);

    private final Map<OsType, YtTablePath> ytTablePathsByOsTypes = new HashMap<>();

    FetchMobileContentFromStoreJobConfig(DirectConfig directConfig) {
        DirectConfig mobileAppsData = directConfig.getBranch("mobile_apps_data");

        for (MobileContentStoreType type : MobileContentStoreType.values()) {
            String ytFolderName = type.getName();
            Optional<DirectConfig> branch = mobileAppsData.findBranch(type.getName());
            branch.ifPresent(conf -> {
                Optional<String> ytCluster = conf.findString("input_cluster");
                Optional<String> ytTableDir = conf.findString("request_table_dir");
                if (ytCluster.isPresent() && ytTableDir.isPresent()) {
                    ytTablePathsByOsTypes.put(YT_PATH_TO_OS_TYPE.get(ytFolderName),
                            new YtTablePath(YtCluster.valueOf(ytCluster.get().toUpperCase()), ytTableDir.get()));
                }
            });
        }
    }

    Map<OsType, YtTablePath> getYtTablePathsByOsTypes() {
        return ytTablePathsByOsTypes;
    }
}
