package ru.yandex.direct.jobs.freelancers;

import java.time.LocalDateTime;

public class YtFreelancerProject {

    private Long projectId;
    private Long freelancerClientId;
    private Long customerClientId;

    private LocalDateTime startDate;
    private LocalDateTime finishDate;

    private String freelancerLogin;
    private Long freelancerUid;
    private String freelancerName;


    public Long getProjectId() {
        return projectId;
    }

    public YtFreelancerProject withProjectId(Long projectId) {
        this.projectId = projectId;
        return this;
    }

    public Long getFreelancerClientId() {
        return freelancerClientId;
    }

    public YtFreelancerProject withFreelancerClientId(Long freelancerClientId) {
        this.freelancerClientId = freelancerClientId;
        return this;
    }

    public Long getCustomerClientId() {
        return customerClientId;
    }

    public YtFreelancerProject withCustomerClientId(Long customerClientId) {
        this.customerClientId = customerClientId;
        return this;
    }

    public LocalDateTime getStartDate() {
        return startDate;
    }

    public YtFreelancerProject withStartDate(LocalDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    public LocalDateTime getFinishDate() {
        return finishDate;
    }

    public YtFreelancerProject withFinishDate(LocalDateTime finishDate) {
        this.finishDate = finishDate;
        return this;
    }

    public String getFreelancerLogin() {
        return freelancerLogin;
    }

    public YtFreelancerProject withFreelancerLogin(String freelancerLogin) {
        this.freelancerLogin = freelancerLogin;
        return this;
    }

    public Long getFreelancerUid() {
        return freelancerUid;
    }

    public YtFreelancerProject withFreelancerUid(Long freelancerUid) {
        this.freelancerUid = freelancerUid;
        return this;
    }

    public String getFreelancerName() {
        return freelancerName;
    }

    public YtFreelancerProject withFreelancerName(String freelancerName) {
        this.freelancerName = freelancerName;
        return this;
    }
}
