package ru.yandex.direct.jobs.freelancers.bsratingimport;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableList;

import ru.yandex.direct.ytwrapper.model.YtField;
import ru.yandex.direct.ytwrapper.model.YtTableRow;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;

/**
 * Таблица с рейтингом фрилансеров, проставляемым ОКР
 * Описаны только поля, используемые при импорте данных
 */
@ParametersAreNonnullByDefault
class FreelancerBsRatingTableRow extends YtTableRow {
    static final String FOLDER_PATH = "//home/bs/freelancers/direct/export";

    private static final YtField<Long> CLIENT_ID = new YtField<>("client_id", Long.class, YtField.SortOrder.ASCENDING);
    private static final YtField<Long> FREELANCER_RANK = new YtField<>("freelancer_rank", Long.class);
    // Тип на самом деле Yson, но наш YtField его не поддерживает
    private static final YtField<String> RATING_DICT = new YtField<>("ratings", String.class);
    private static final YtField<String> RATING_KEY = new YtField<>("production_freelancer_rating", String.class);

    FreelancerBsRatingTableRow() {
        this(Collections.emptyList());
    }

    private FreelancerBsRatingTableRow(Collection<YtField> fields) {
        super(ImmutableList.<YtField>builder()
                .addAll(Arrays.asList(CLIENT_ID, FREELANCER_RANK, RATING_DICT, RATING_KEY))
                .addAll(fields)
                .build());
    }

    Long getClientId() {
        return valueOf(CLIENT_ID);
    }

    Long getFreelancerRank() {
        return valueOf(FREELANCER_RANK);
    }

    Map<String, YTreeNode> getRatingDict() {
        return getData().getOrThrow("ratings").mapNode().asMap();
    }

    String getRatingKey() {
        return valueOf(RATING_KEY);
    }
}
