package ru.yandex.direct.jobs.freelancers.certimport;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.freelancer.model.Freelancer;
import ru.yandex.direct.core.entity.freelancer.model.FreelancerBase;
import ru.yandex.direct.core.entity.freelancer.model.FreelancerCertificate;
import ru.yandex.direct.core.entity.freelancer.model.FreelancerCertificateType;
import ru.yandex.direct.core.entity.freelancer.repository.FreelancerRepository;
import ru.yandex.direct.core.entity.freelancer.service.FreelancerCertificateService;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelChanges;

import static ru.yandex.direct.core.entity.freelancer.model.FreelancerCertificateType.DIRECT;
import static ru.yandex.direct.core.entity.freelancer.model.FreelancerCertificateType.DIRECT_PRO;

@Service
public class FreelancerCertificatesUpdateService {
    public static final Set<FreelancerCertificateType> VALID_CERT_TYPES = Set.of(DIRECT, DIRECT_PRO);
    private final FreelancerRepository freelancerRepository;
    private final FreelancerCertificateService freelancerCertificateService;

    @Autowired
    public FreelancerCertificatesUpdateService(FreelancerRepository freelancerRepository,
                                               FreelancerCertificateService freelancerCertificateService) {
        this.freelancerRepository = freelancerRepository;
        this.freelancerCertificateService = freelancerCertificateService;
    }

    public void updateCertificates(int shard) {
        List<Freelancer> freelancers = freelancerRepository.getAllEnabledFreelancers(shard);
        Map<Long, List<FreelancerCertificate>> certsByFreelancerId =
                freelancerCertificateService.getFlCertsFromExternal(freelancers);

        List<AppliedChanges<FreelancerBase>> appliedChanges = new ArrayList<>(freelancers.size());
        for (Freelancer freelancer : freelancers) {
            Long freelancerId = freelancer.getId();
            List<FreelancerCertificate> certificates = certsByFreelancerId.get(freelancerId);
            boolean hasDirectCert =
                    certificates.stream().anyMatch(s -> VALID_CERT_TYPES.contains(s.getType()));
            ModelChanges<FreelancerBase> modelChanges = new ModelChanges<>(freelancerId, FreelancerBase.class)
                    .processNotNull(certificates, FreelancerBase.CERTIFICATES)
                    .process(hasDirectCert, FreelancerBase.IS_SEARCHABLE);
            AppliedChanges<FreelancerBase> freelancerBaseAppliedChanges = modelChanges.applyTo(freelancer);
            appliedChanges.add(freelancerBaseAppliedChanges);
        }
        freelancerRepository.updateFreelancer(shard, appliedChanges);
    }

}
