package ru.yandex.direct.jobs.freelancers.moderation;

import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.tvm.TvmService;

@SuppressWarnings("WeakerAccess")
public class LogbrokerConsumerProperties {

    private final DirectConfig consumerSectionConfig;

    private LogbrokerConsumerProperties(DirectConfig consumerSectionConfig) {
        this.consumerSectionConfig = consumerSectionConfig;
    }

    public static LogbrokerConsumerProperties createInstance(DirectConfig directConfig,
                                                             String configSectionName) {
        DirectConfig consumerSectionConfig = directConfig.getBranch(configSectionName);
        return new LogbrokerConsumerProperties(consumerSectionConfig);
    }

    public String getHost() {
        return consumerSectionConfig.getString("host");
    }

    public long getTimeoutSec() {
        return consumerSectionConfig.getLong("timeout_sec");
    }

    public String getReadTopic() {
        return consumerSectionConfig.getString("read_topic");
    }

    public String getConsumerName() {
        return consumerSectionConfig.getString("consumer_name");
    }

    public TvmService getTvmService() {
        return TvmService.fromStringStrict(consumerSectionConfig.getString("tvm_service_name"));
    }

}
