package ru.yandex.direct.jobs.freelancers.moderation;

import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.tvm.TvmService;

@SuppressWarnings("WeakerAccess")
public class LogbrokerProducerProperties {

    private final DirectConfig producerSectionConfig;

    private LogbrokerProducerProperties(DirectConfig producerSectionConfig) {
        this.producerSectionConfig = producerSectionConfig;
    }

    public static LogbrokerProducerProperties createInstance(DirectConfig directConfig,
                                                             String configSectionName) {
        DirectConfig producerSectionConfig = directConfig.getBranch(configSectionName);
        return new LogbrokerProducerProperties(producerSectionConfig);
    }

    public String getWriteTopic() {
        return producerSectionConfig.getString("write_topic");
    }

    public String getHost() {
        return producerSectionConfig.getString("host");
    }

    public long getTimeoutSec() {
        return producerSectionConfig.getLong("timeout_sec");
    }

    public TvmService getTvmService() {
        return TvmService.fromStringStrict(producerSectionConfig.getString("tvm_service_name"));
    }

}
