package ru.yandex.direct.jobs.freelancers.moderation.receiving;

import java.util.Map;
import java.util.Set;

import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;

import ru.yandex.direct.core.entity.freelancer.model.FreelancerCard;
import ru.yandex.direct.core.entity.freelancer.model.FreelancerCardModeration;
import ru.yandex.direct.core.entity.freelancer.model.FreelancersCardDeclineReason;
import ru.yandex.direct.core.entity.freelancer.model.FreelancersCardStatusModerate;
import ru.yandex.direct.jobs.freelancers.moderation.receiving.model.CardModerationVerdict;
import ru.yandex.direct.jobs.freelancers.moderation.receiving.model.VerdictMeta;
import ru.yandex.direct.jobs.freelancers.moderation.receiving.model.VerdictResult;

import static java.util.Collections.emptySet;

public class Converter {

    private static final Map<String, FreelancersCardDeclineReason> DECLINE_REASON_BY_MODERATION_KEY =
            StreamEx.of(FreelancersCardDeclineReason.values())
                    .mapToEntry(FreelancersCardDeclineReason::getModerationName, v -> v)
                    .toMap();

    static FreelancerCardModeration createModeration(CardModerationVerdict verdict) {
        VerdictMeta verdictMeta = verdict.getMeta();
        VerdictResult verdictResult = verdict.getResult();

        String verdictKey = verdictResult.getVerdict();
        FreelancersCardStatusModerate statusModerate = verdictKey
                .equalsIgnoreCase("Yes") ?
                FreelancersCardStatusModerate.ACCEPTED : FreelancersCardStatusModerate.DECLINED;

        String[] reasons = verdictResult.getReason();
        Set<FreelancersCardDeclineReason> declineReason;
        if (reasons == null || reasons.length == 0) {
            declineReason = emptySet();
        } else {
            declineReason = StreamEx.of(reasons)
                    .map(String::trim)
                    .filter(StringUtils::isNotBlank)
                    .map(DECLINE_REASON_BY_MODERATION_KEY::get)
                    .toSet();
        }
        return new FreelancerCard()
                .withId(verdictMeta.getFreelancerCardId())
                .withFreelancerId(verdictMeta.getClientId())
                .withStatusModerate(statusModerate)
                .withDeclineReason(declineReason);
    }
}
