package ru.yandex.direct.jobs.freelancers.moderation.sending;

import java.util.Map;

import ru.yandex.direct.core.entity.freelancer.model.FreelancerCard;
import ru.yandex.direct.jobs.freelancers.moderation.sending.model.CardModerationRequest;
import ru.yandex.direct.jobs.freelancers.moderation.sending.model.RequestData;
import ru.yandex.direct.jobs.freelancers.moderation.sending.model.RequestMeta;
import ru.yandex.direct.jobs.freelancers.moderation.sending.model.Workflow;

class Converter {
    /**
     * Название сервиса в процессах модерации.
     */
    private static final String SERVICE = "direct";
    /**
     * Тип модерации.
     */
    private static final String TYPE = "freelancer_card";

    static CardModerationRequest createRequest(FreelancerCard card, Map<Long, String> avatarUrlByAvatarId) {
        String href = card.getContacts().getSiteUrl();
        String imgUrl = avatarUrlByAvatarId.get(card.getAvatarId());
        RequestData requestData = new RequestData()
                .withDescription(card.getBriefInfo())
                .withHref(href)
                .withImgUrl(imgUrl);
        RequestMeta requestMeta = new RequestMeta()
                .withClientId(card.getFreelancerId())
                .withFreelancerCardId(card.getId());
        long currentTimeMillis = System.currentTimeMillis();
        return new CardModerationRequest()
                .withData(requestData)
                .withMeta(requestMeta)
                .withService(SERVICE)
                .withType(TYPE)
                .withWorkflow(Workflow.COMMON)
                .withUnixTime(currentTimeMillis);
    }
}
