package ru.yandex.direct.jobs.freelancers.moderation.sending;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.common.db.PpcPropertiesSupport;

import static org.apache.commons.lang3.StringUtils.isNotBlank;

@Service
public class LbSeqIdService {
    static final String SEQ_ID_PROPERTY_KEY_PATTERN = "fl_card_moderation_seq_id_shard_";

    private final PpcPropertiesSupport ppcPropertiesSupport;

    @Autowired
    public LbSeqIdService(PpcPropertiesSupport ppcPropertiesSupport) {
        this.ppcPropertiesSupport = ppcPropertiesSupport;
    }

    long getNextCardModerationSeqId(int shard) {
        String shardAsString = Integer.toString(shard);
        String propertyKey = SEQ_ID_PROPERTY_KEY_PATTERN + shardAsString;
        String propertyValue = ppcPropertiesSupport.get(propertyKey);
        long shardSeqId = isNotBlank(propertyValue) ? Long.parseLong(propertyValue) : 0L;
        shardSeqId++;
        propertyValue = Long.toString(shardSeqId);
        ppcPropertiesSupport.set(propertyKey, propertyValue);
        return shardSeqId;
    }
}
