package ru.yandex.direct.jobs.freelancers.moderation.sending.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Заявка на модерацию
 */
@SuppressWarnings("WeakerAccess")
public class CardModerationRequest {
    private String service;

    private String type;

    private RequestMeta meta;

    private RequestData data;

    private Workflow workflow;

    private Long unixTime;

    @JsonProperty("service")
    public String getService() {
        return service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public CardModerationRequest withService(String service) {
        setService(service);
        return this;
    }

    @JsonProperty("type")
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public CardModerationRequest withType(String type) {
        setType(type);
        return this;
    }

    @JsonProperty("meta")
    public RequestMeta getMeta() {
        return meta;
    }

    public void setMeta(RequestMeta meta) {
        this.meta = meta;
    }

    public CardModerationRequest withMeta(RequestMeta meta) {
        setMeta(meta);
        return this;
    }

    @JsonProperty("data")
    public RequestData getData() {
        return data;
    }

    public void setData(RequestData data) {
        this.data = data;
    }

    public CardModerationRequest withData(RequestData data) {
        setData(data);
        return this;
    }

    @JsonProperty("workflow")
    @JsonFormat(shape = JsonFormat.Shape.OBJECT)
    public Workflow getWorkflow() {
        return workflow;
    }

    public void setWorkflow(Workflow workflow) {
        this.workflow = workflow;
    }

    public CardModerationRequest withWorkflow(Workflow workflow) {
        setWorkflow(workflow);
        return this;
    }

    @JsonProperty("unixtime")
    public Long getUnixTime() {
        return unixTime;
    }

    public void setUnixTime(Long unixTime) {
        this.unixTime = unixTime;
    }

    public CardModerationRequest withUnixTime(Long unixTime) {
        setUnixTime(unixTime);
        return this;
    }

}
