package ru.yandex.direct.jobs.grut.watchlog.components

import java.time.Duration
import java.util.concurrent.CompletableFuture
import java.util.function.Supplier
import ru.yandex.direct.binlogbroker.logbroker_utils.writer.AbstractLogbrokerWriterImpl
import ru.yandex.direct.binlogbroker.logbroker_utils.writer.LogbrokerWriterRetryConfig
import ru.yandex.direct.ess.router.models.TEssEvent
import ru.yandex.inside.yt.kosher.common.YtTimestamp
import ru.yandex.kikimr.persqueue.producer.AsyncProducer

class GrutWatchlogLogbrokerWriter(
    logbrokerProducerSupplier: Supplier<CompletableFuture<AsyncProducer>>,
    logbrokerTimeout: Duration,
    retryCount: Int,
) : AbstractLogbrokerWriterImpl<TEssEvent>(logbrokerProducerSupplier, logbrokerTimeout, LogbrokerWriterRetryConfig(retryCount)) {

    override fun makeRequest(event: TEssEvent): LogbrokerWriteRequest {
        return LogbrokerWriteRequestBuilder()
            .withData(event.toByteArray())
            // TODO: убрать копипасту
            // Пробрасываем create time из исходного источника данных, чтобы отслеживать отставание через метрики LB
            .withCreateTime(YtTimestamp.valueOf(event.event.timestamp).instant.toEpochMilli())
            .build()
    }
}
