package ru.yandex.direct.jobs.grut.watchlog.components.enrichers

import ru.yandex.direct.core.entity.uac.grut.NonTransactionalGrutContext
import ru.yandex.direct.core.grut.api.CampaignGrutApi
import ru.yandex.direct.ess.router.models.TEssEvent
import ru.yandex.grut.client.GrutClient
import ru.yandex.grut.objects.proto.client.Schema.TBannerCandidateMeta

class BannerCandidateDirectCampaignIdEnricher(
    nextEnricher: EventEnricher? = null,
    grutClient: GrutClient,
) : EventEnricher(nextEnricher) {

    private val campaignApi = CampaignGrutApi(NonTransactionalGrutContext(grutClient))

    override fun enrich(events: List<TEssEvent>): List<TEssEvent> {
        val eventToMeta = events.asSequence()
            .map { it to TBannerCandidateMeta.parseFrom(it.event.objectMeta) }
            .toMap()
        val grutCampaignIds = eventToMeta.values.asSequence()
            .map { it.campaignId }
            .filter { it != 0L }
            .toSet()

        val campaignIdToDirectCampaignId = campaignApi.getCampaigns(grutCampaignIds).associate {
            it.meta.id to it.meta.directId
        }

        return events.map {
            val newDirectCampaignId = campaignIdToDirectCampaignId[eventToMeta[it]?.campaignId] ?: return@map it

            it.toBuilder().apply {
                this.directCampaignId = newDirectCampaignId
            }.build()
        }
    }
}
