package ru.yandex.direct.jobs.grut.watchlog.components.enrichers

import ru.yandex.direct.core.entity.uac.grut.NonTransactionalGrutContext
import ru.yandex.direct.core.grut.api.CampaignGrutApi
import ru.yandex.direct.dbutil.sharding.ShardHelper
import ru.yandex.direct.dbutil.sharding.ShardKey
import ru.yandex.direct.ess.router.models.TEssEvent
import ru.yandex.grut.client.GrutClient
import ru.yandex.grut.objects.proto.client.Schema.TBannerCandidateMeta

class BannerCandidateShardEnricher(
    nextEnricher: EventEnricher? = null,
    grutClient: GrutClient,
    private val shardHelper: ShardHelper,
) : EventEnricher(nextEnricher) {

    private val campaignApi = CampaignGrutApi(NonTransactionalGrutContext(grutClient))

    override fun enrich(events: List<TEssEvent>): List<TEssEvent> {
        val eventsWithoutShard = events.filter { it.event.transactionContext.shard == 0 }
        if (eventsWithoutShard.isEmpty()) {
            return events
        }

        val eventToMeta = eventsWithoutShard.asSequence()
            .map { it to TBannerCandidateMeta.parseFrom(it.event.objectMeta) }
            .toMap()
        val grutCampaignIds = eventToMeta.values.asSequence()
            .map { it.campaignId }
            .filter { it != 0L }
            .toSet()
        val campaignIdToDirectCampaignId = campaignApi.getCampaigns(grutCampaignIds).associate {
            it.meta.id to it.meta.directId
        }
        val directCampaignIdToShard = shardHelper.groupByShard(campaignIdToDirectCampaignId.values, ShardKey.CID)
            .shardedDataMap.entries.flatMap { e -> e.value.map { it to e.key } }.toMap()

        return events.map {
            val internalEvent = it.event
            if (internalEvent.transactionContext.shard != 0) {
                it
            } else {
                val newShard = directCampaignIdToShard[campaignIdToDirectCampaignId[eventToMeta[it]?.campaignId]] ?: return@map it

                val newTransactionContext = internalEvent.transactionContext.toBuilder().apply {
                    shard = newShard
                }.build()
                val newInternalEvent = internalEvent.toBuilder().apply {
                    transactionContext = newTransactionContext
                }.build()
                it.toBuilder().apply {
                    event = newInternalEvent
                }.build()
            }
        }
    }
}
