package ru.yandex.direct.jobs.grut.watchlog.components.enrichers

import ru.yandex.direct.dbutil.sharding.ShardHelper
import ru.yandex.direct.dbutil.sharding.ShardKey
import ru.yandex.direct.ess.router.models.TEssEvent
import ru.yandex.grut.objects.proto.client.Schema.TCampaignMeta

class CampaignShardEnricher(
    nextEnricher: EventEnricher? = null,
    private val shardHelper: ShardHelper,
) : EventEnricher(nextEnricher) {

    override fun enrich(events: List<TEssEvent>): List<TEssEvent> {
        val eventsWithoutShard = events.filter { it.event.transactionContext.shard == 0 }
        if (eventsWithoutShard.isEmpty()) {
            return events
        }

        val eventToMeta = eventsWithoutShard.asSequence()
            .map { it to TCampaignMeta.parseFrom(it.event.objectMeta) }
            .toMap()
        val eventCampaignIds = eventToMeta.values.map { it.id }

        val campaignIdToShard =
            shardHelper.groupByShard(eventCampaignIds, ShardKey.CID).shardedDataMap.entries.flatMap { e ->
                e.value.map { it to e.key }
            }.toMap()

        return events.map {
            val internalEvent = it.event
            if (internalEvent.transactionContext.shard != 0) {
                it
            } else {
                val newShard = campaignIdToShard[eventToMeta[it]?.id] ?: return@map it

                val newTransactionContext = internalEvent.transactionContext.toBuilder().apply {
                    shard = newShard
                }.build()
                val newInternalEvent = internalEvent.toBuilder().apply {
                    transactionContext = newTransactionContext
                }.build()
                it.toBuilder().apply {
                    event = newInternalEvent
                }.build()
            }
        }
    }
}
