package ru.yandex.direct.jobs.grut.watchlog.components.enrichers

import ru.yandex.direct.ess.router.models.TEssEvent

abstract class EventEnricher(
    private val nextEnricher: EventEnricher? = null,
) {

    fun enrichChain(events: List<TEssEvent>): List<TEssEvent> {
        val enrichedEvents = enrich(events)
        return nextEnricher?.enrichChain(enrichedEvents) ?: enrichedEvents
    }

    protected abstract fun enrich(events: List<TEssEvent>): List<TEssEvent>
}
