package ru.yandex.direct.jobs.grut.watchlog.components.processors

import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.db.PpcPropertyName
import ru.yandex.direct.common.db.PpcPropertyNames
import ru.yandex.direct.dbutil.sharding.ShardHelper
import ru.yandex.direct.jobs.grut.watchlog.components.GrutWatchlogLogbrokerWriter
import ru.yandex.direct.jobs.grut.watchlog.components.enrichers.BannerCandidateDirectCampaignIdEnricher
import ru.yandex.direct.jobs.grut.watchlog.components.enrichers.BannerCandidateShardEnricher
import ru.yandex.grut.client.GrutClient
import ru.yandex.grut.objectwatcher.ObjectWatcher
import ru.yandex.grut.objects.proto.client.Schema.EObjectType

class BannerCandidateWatchlogProcessor(
    ppcPropertiesSupport: PpcPropertiesSupport,
    grutClient: GrutClient,
    getLogrokerWriterByShard: (Int) -> GrutWatchlogLogbrokerWriter,
    watchlogConsumerPrefix: String,
    shardHelper: ShardHelper,
) : WatchlogProcessor(ppcPropertiesSupport, ObjectWatcher(grutClient), getLogrokerWriterByShard, watchlogConsumerPrefix) {

    override val enricherChain = BannerCandidateDirectCampaignIdEnricher(grutClient = grutClient).let {
        BannerCandidateShardEnricher(it, grutClient, shardHelper)
    }

    override fun getObjectType(): EObjectType = EObjectType.OT_BANNER_CANDIDATE

    override fun eventCountLimit(): ULong = 1000u

    override fun getProcessorPropertyName(): PpcPropertyName<Boolean> =
        PpcPropertyNames.WATCHLOGBROKER_BANNER_CANDIDATE_PROCESSOR_ENABLED
}
