package ru.yandex.direct.jobs.grut.watchlog.components.processors

import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.db.PpcPropertyName
import ru.yandex.direct.common.db.PpcPropertyNames
import ru.yandex.direct.dbutil.sharding.ShardHelper
import ru.yandex.direct.jobs.grut.watchlog.components.GrutWatchlogLogbrokerWriter
import ru.yandex.direct.jobs.grut.watchlog.components.enrichers.CampaignShardEnricher
import ru.yandex.grut.client.GrutClient
import ru.yandex.grut.objectwatcher.ObjectWatcher
import ru.yandex.grut.objects.proto.client.Schema.EObjectType

class CampaignWatchlogProcessor(
    ppcPropertiesSupport: PpcPropertiesSupport,
    grutClient: GrutClient,
    getLogrokerWriterByShard: (Int) -> GrutWatchlogLogbrokerWriter,
    watchlogConsumerPrefix: String,
    shardHelper: ShardHelper,
) : WatchlogProcessor(ppcPropertiesSupport, ObjectWatcher(grutClient), getLogrokerWriterByShard, watchlogConsumerPrefix) {

    override val enricherChain = CampaignShardEnricher(shardHelper = shardHelper)

    override fun getObjectType(): EObjectType = EObjectType.OT_CAMPAIGN

    override fun getProcessorPropertyName(): PpcPropertyName<Boolean> =
        PpcPropertyNames.WATCHLOGBROKER_CAMPAIGN_PROCESSOR_ENABLED

    override fun eventCountLimit(): ULong = 1000u
}
